PSCAD 4.2.0

Settings
 {
 Id = "913140633.1144362299"
 Author = "jayas.jayas"
 Desc = "Induction motor starting example"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 1
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 5
  Step = 5e-005
  Plot = 0.001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "Untitled.out"
  SFile = "AutoSnap.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Main")
  {
  Desc = " EXAMPLE 7"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,48,[597,467],100)
   {
   -Sticky-([90,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 90,990,360,1080
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Load torque variation as a function
of speed

Tload = k*w **2+ b


"
    }
   -Wire-([720,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,900],0,0,-1)
    {
    Name = "W"
    }
   0.time-sig([414,990],0,0,170)
    {
    }
   -Wire-([450,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([594,882],0,0,-1)
    {
    Name = "DIST"
    }
   0.time-sig([414,882],0,0,110)
    {
    }
   -Wire-([450,882],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([432,288],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([432,360],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([306,414],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.const([396,288],0,0,30)
    {
    Name = ""
    Value = "0"
    }
   -Wire-([720,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,936],0,0,-1)
    {
    Name = "Ix"
    }
   0.datalabel([594,990],4,0,-1)
    {
    Name = "StoT"
    }
   0.unity([594,882],0,0,130)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([594,990],0,0,190)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([468,288],6,0,-1)
    {
    Name = "WIN"
    }
   0.sumjct([288,864],0,0,240)
    {
    DPath = "1"
    A = "0"
    B = "0"
    C = "0"
    D = "1"
    E = "0"
    F = "1"
    G = "0"
    }
   0.datalabel([324,864],0,0,-1)
    {
    Name = "Tload"
    }
   -Wire-([720,972],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,972],0,0,-1)
    {
    Name = "Tload"
    }
   0.wound_rotor([558,324],0,0,260)
    {
    Name = "WR"
    Pbase = "1.2 [MVA]"
    Vbase = "13.8 [kV]"
    OMEG = "$(freq)"
    TRN = "2.637687"
    J = "3.7267 [s]"
    D = "0.01 [pu]"
    View = "1"
    ERC = "1"
    MM = "0"
    SNP = "1"
    Cage = "0"
    NCW = "1"
    Msat = "0"
    Lsat = "0"
    R1 = "0.0034 [pu]"
    R2 = "0.00607 [pu]"
    R3 = "0.298 [pu]"
    R4 = "0.018 [pu]"
    R5 = "0.018 [pu]"
    Xmd = "0.9 [pu]"
    Xa = "0.0102 [pu]"
    Xkd1 = "0.011 [pu]"
    Xkd2 = "0.05 [pu]"
    Xkd3 = "0.05 [pu]"
    Xkd4 = "0.05 [pu]"
    Xkd12 = "0.02 [pu]"
    Xkd13 = "0.02 [pu]"
    Xkd14 = "0.02 [pu]"
    Xkd23 = "0.02 [pu]"
    Xkd24 = "0.02 [pu]"
    Xkd34 = "0.02 [pu]"
    I1M = "0.0 [pu]"
    V1M = "0.0 [pu]"
    I2M = "0.5 [pu]"
    V2M = "0.5 [pu]"
    I3M = "0.8 [pu]"
    V3M = "0.79 [pu]"
    I4M = "1.0 [pu]"
    V4M = "0.947 [pu]"
    I5M = "1.6 [pu]"
    V5M = "1.076 [pu]"
    I6M = "1.7 [pu]"
    V6M = "1.2 [pu]"
    I7M = "2.1pu"
    V7M = "1.26 [pu]"
    I8M = "2.4 [pu]"
    V8M = "1.32 [pu]"
    I9M = "3.2 [pu]"
    V9M = "1.42 [pu]"
    I10M = "4.2 [pu]"
    V10M = "1.5 [pu]"
    I1 = "0.0 [pu]"
    V1 = "0.0 [pu]"
    I2 = "1.196 [pu]"
    V2 = "0.286 [pu]"
    I3 = "1.82 [pu]"
    V3 = "0.4 [pu]"
    I4 = "2.861 [pu]"
    V4 = "0.564 [pu]"
    I5 = "5.882 [pu]"
    V5 = "0.981 [pu]"
    I6 = "-1.0 [pu]"
    V6 = "-1.0 [pu]"
    I7 = "-1.0 [pu]"
    V7 = "-1.0 [pu]"
    I8 = "-1.0 [pu]"
    V8 = "-1.0 [pu]"
    I9 = "-1.0 [pu]"
    V9 = "-1.0 [pu]"
    I10 = "-1.0 [pu]"
    V10 = "-1.0 [pu]"
    MSF = ""
    LSF = ""
    Spd = "W"
    Tel = "Te"
    TmOp = ""
    ThetaR = ""
    }
   -Wire-([522,198],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([594,198],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([558,198],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([522,144],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([558,144],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([594,144],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([522,144],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([468,216],0,0,-1)
    {
    Name = "Rrotor"
    }
   0.var([360,216],0,23440800,10)
    {
    Name = "Rrotor"
    Group = ""
    Display = "0"
    Max = "10"
    Min = "0.0"
    Value = "1.2"
    Units = "ohm"
    Collect = "1"
    }
   0.varrlc([558,162],1,0,320)
    {
    RLC = "0"
    R = "Rrotor"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([594,162],1,0,310)
    {
    RLC = "0"
    R = "Rrotor"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.varrlc([522,162],1,0,330)
    {
    RLC = "0"
    R = "Rrotor"
    L = "1.0 [H]"
    C = "1.0 [uF]"
    E = "0.0 [kV]"
    I = ""
    }
   0.var([288,972],3,23442480,150)
    {
    Name = "Stdstill torq - b"
    Group = ""
    Display = "0"
    Max = "10"
    Min = "0.0"
    Value = "0.0"
    Units = "pu"
    Collect = "1"
    }
   -Wire-([288,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([216,900],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.var([216,972],3,23443360,140)
    {
    Name = "Gradient -k"
    Group = ""
    Display = "0"
    Max = "15"
    Min = "0.0"
    Value = "0.85"
    Units = "pu"
    Collect = "1"
    }
   -Sticky-([180,936],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,936,198,972
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "k"
    }
   -Sticky-([252,936],0)
    {
    Name = ""
    Font = 1
    Bounds = 252,936,270,972
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "b"
    }
   -Wire-([396,216],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.annotation([522,918],0,0,-1)
    {
    AL1 = "Disturb Tin"
    AL2 = "@ 3 second"
    }
   -Wire-([378,486],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.select([378,414],0,0,250)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.datalabel([306,414],0,0,-1)
    {
    Name = "Tload"
    }
   0.const([306,378],0,0,70)
    {
    Name = ""
    Value = "1.8"
    }
   0.datalabel([378,486],0,0,-1)
    {
    Name = "DIST"
    }
   -Wire-([414,414],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([432,360],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([432,324],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([720,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,864],0,0,-1)
    {
    Name = "Te"
    }
   0.pgb([756,864],0,23151696,290)
    {
    Name = "Electric torque"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-5"
    Max = "20"
    }
   0.mult([216,864],0,0,230)
    {
    }
   0.datalabel([108,864],0,0,-1)
    {
    Name = "W"
    }
   -Wire-([882,324],0,0,-1)
    {
    Vertex="0,0;90,0"
    }
   -Wire-([1098,324],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([900,324],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([720,1008],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,1008],0,0,-1)
    {
    Name = "Vload"
    }
   -Wire-([720,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,1044],0,0,-1)
    {
    Name = "Iload"
    }
   0.pgb([756,1044],0,23033256,210)
    {
    Name = "Iload"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.2"
    Max = "0.3"
    }
   0.ammeter([882,324],4,0,80)
    {
    Name = "Ix"
    }
   0.xfmr-3p2w([1062,324],0,0,-1)
    {
    Name = ""
    Tmva = "100.0 [MVA]"
    f = "$(freq)"
    YD1 = "1"
    YD2 = "0"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "13.8 [kV]"
    V2 = "1.732 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.source3([900,486],5,0,-1)
    {
    Name = "Source"
    Type = "2"
    Ctrl = "0"
    MVA = "1.5 [MVA]"
    Vm = "132 [kV]"
    F = "$(freq)"
    Tc = "0.0 [s]"
    ZSeq = "0"
    Imp = "0"
    Exph = "0"
    View = "1"
    Term = "0"
    R1s = "0.5 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "136 [kV]"
    F0 = "$(freq)"
    Ph = "90 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.ground([1062,360],1,0,-1)
    {
    }
   0.pgb([756,828],0,24752160,100)
    {
    Name = "TERMINAL VOLTAGE"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "20"
    }
   -Wire-([648,324],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.breaker3([720,324],0,0,60)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "0"
    DisPQ = "0"
    NAME = "BRK"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = ""
    IBRB = "Ib"
    IBRC = "Ic"
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "0 [MW]"
    Q = "0 [MVAR]"
    }
   0.ground([864,396],2,0,-1)
    {
    }
   0.ground([864,414],2,0,-1)
    {
    }
   0.xfmr-3p2w([792,324],4,0,-1)
    {
    Name = ""
    Tmva = "1 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.02 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "12 [kV]"
    V2 = "13.8 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([792,360],1,0,-1)
    {
    }
   0.ground([810,360],1,0,-1)
    {
    }
   -Wire-([720,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,234],0,0,-1)
    {
    Name = "BRK"
    }
   0.xfmr-3p2w([900,396],5,0,-1)
    {
    Name = ""
    Tmva = "1 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.02 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "132 [kV]"
    V2 = "13.8 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0.1 [s]"
    Im1 = "1 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = ""
    IMB = ""
    IMC = ""
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.ground([900,522],1,0,-1)
    {
    }
   0.pgb([756,1008],0,24758616,200)
    {
    Name = "Vload"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-15"
    Max = "15"
    }
   0.pgb([756,900],0,24760352,280)
    {
    Name = "Speed"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "0"
    Max = "1"
    }
   0.pgb([756,972],0,25386520,270)
    {
    Name = "Tload"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-1"
    Max = "1"
    }
   0.pgb([756,936],0,25387664,160)
    {
    Name = "Current"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1"
    Max = "1"
    }
   0.compare([522,990],0,0,180)
    {
    X = "0.0001"
    OL = "0"
    OH = "0"
    INTR = "0"
    }
   0.compare([522,882],0,0,120)
    {
    X = "3"
    OL = "0"
    OH = "1"
    INTR = "0"
    }
   0.tbreakn([792,234],0,0,20)
    {
    NUMS = "1"
    INIT = "1"
    TO1 = "0.5 [s]"
    TO2 = "1.05 [s]"
    }
   0.annotation([558,432],2,0,-1)
    {
    AL1 = "INDUCTION MOTOR"
    AL2 = "13.8 kV, Wound rotor type"
    }
   0.datalabel([468,360],4,0,-1)
    {
    Name = "TIN"
    }
   0.annotation([522,1026],0,0,-1)
    {
    AL1 = "Switch to Torque"
    AL2 = "input at 0.5 Second"
    }
   -Sticky-([504,36],0)
    {
    Name = ""
    Font = 2
    Bounds = 504,36,1062,72
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "STARTUP TRANSIENTS OF AN INDUCTION MOTOR"
    }
   0.pgb([432,414],0,25420184,300)
    {
    Name = "Torque Input"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "pu"
    mrun = "0"
    Pol = "0"
    Min = "-5"
    Max = "20"
    }
   0.breakout([558,270],3,0,-1)
    {
    Dis = "0"
    }
   -Sticky-([1116,396],0)
    {
    Name = ""
    Font = 1
    Bounds = 1116,396,1224,432
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Passive load
"
    }
   -Sticky-([522,108],0)
    {
    Name = ""
    Font = 1
    Bounds = 522,108,630,144
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
External rotor resistance
"
    }
   0.consti([396,324],0,0,40)
    {
    Name = ""
    Value = "0"
    }
   -Sticky-([54,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,504,540,828
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Induction motor start up example:

The wound rotor machine is used.

The motor is started from zero speed. 
The mechanical torque applied, Tm, is varied as a function of speed. 
ie.
Tm = Tload = k*w*w + b
w = speed
k,b = constants.

The machine accelerates if Te>Tm

At 3s, the mechanical torque is switched to 1.8 pu using a  'controlled' switch. The machine goes through a transient state and settles at a new speed.

The start up characteristics depend on the external resistance, Rrotor, connected to the rotor. This value can be changed using a 'slider'. Parameters such as machine inertia, damping can also be changed inside the component to study their impact on start up."
    }
   0.square([144,864],0,0,220)
    {
    Dim = "1"
    }
   -ControlPanel-([594,594],0)
    {
    Name = "Controls"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 594,594
    Extents = 0,0,252,162
    Slider(23440800)
    Slider(23443360)
    Slider(23442480)
    }
   0.multimeter([630,324],0,0,50)
    {
    MeasI = "0"
    MeasV = "0"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = ""
    P = ""
    Q = ""
    Vrms = "Vrms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([720,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,828],0,0,-1)
    {
    Name = "Vrms"
    }
   0.reactive_load([1206,324],0,0,-1)
    {
    S = "0.24 [MVAR]"
    V = "1.732 [kV]"
    F = "$(freq)"
    SD = "0"
    }
   0.resistive_load([1134,324],0,0,-1)
    {
    P = "0.6 [MW]"
    V = "1.732 [kV]"
    SD = "0"
    }
   0.multimeter([990,324],0,0,90)
    {
    MeasI = "1"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "0"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = "Iload"
    VolI = "Vload"
    P = ""
    Q = ""
    Vrms = "Vrms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Plot-([972,468],0)
    {
    Title = ""
    Draw = 1
    Area = [0,0,594,738]
    Posn = [972,468]
    Icon = [-1,-1]
    Extents = 0,0,594,738
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,594,135],"Speed")
     {
     Options = 0
     Units = "pu"
     Curve(24760352,"Speed",0,,,)
     }
    Graph([0,135],[0,0,594,135],"Torque")
     {
     Options = 0
     Units = "pu"
     Curve(23151696,"Electric torque",1,,,)
     Curve(25420184,"Torque Input",0,,,)
     }
    Graph([0,270],[0,0,594,135],"Motor Current")
     {
     Options = 0
     Units = "kA"
     Curve(25387664,"Current",0,,,)
     }
    Graph([0,405],[0,0,594,135],"Load Voltage")
     {
     Options = 0
     Units = "kV"
     Curve(24758616,"Vload",0,,,)
     }
    Graph([0,540],[0,0,594,135],"Load Current")
     {
     Options = 0
     Units = "kA"
     Curve(23033256,"Iload",0,,,)
     }
    }
   }
  }
 }

